const whatsapp = require("wa-multi-session");
const ValidationError = require("../../utils/error");
const { responseSuccessWithData } = require("../../utils/response");
const express = require('express');
const app = require("express")()
const bodyParser = require("body-parser");
const cors = require('cors');
app.use(cors());
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));

const {
  default: makeWASocket,
  DisconnectReason,
  delay,
  fetchLatestBaileysVersion,
  isJidBroadcast,
  makeCacheableSignalKeyStore,
  makeInMemoryStore,
  useMultiFileAuthState,
} = require("@whiskeysockets/baileys");

const log = (pino = require("pino"));
const { session } = { "session": "baileys_auth_info" };
const { Boom } = require("@hapi/boom");
const fileUpload = require('express-fileupload');
// enable files upload
app.use(fileUpload({
  createParentPath: true
}));
// http://expressjs.com/en/api.html#req.body
app.use(cors());
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));
const server = require("http").createServer(app);
const io = require("socket.io")(server);
//const port = process.env.PORT || 8005;
const qrcode = require("qrcode");
const NodeCache = require('node-cache');
const msgRetryCounterCache = new NodeCache();
const baileys_1 = require("@whiskeysockets/baileys");
const doReplies = !process.argv.includes('--no-reply')
//send a template message!



//https://stackoverflow.com/questions/24170933/convert-unix-timestamp-to-date-time-javascript
function convertTimestamp(timestamp) {
  var d = new Date(timestamp * 1000), // Convert the passed timestamp to milliseconds
      yyyy = d.getFullYear(),
      mm = ('0' + (d.getMonth() + 1)).slice(-2),  // Months are zero based. Add leading 0.
      dd = ('0' + d.getDate()).slice(-2),         // Add leading 0.
      hh = d.getHours(),
      h = hh,
      min = ('0' + d.getMinutes()).slice(-2),     // Add leading 0.
      ampm = 'AM',
      time;

  if (hh > 12) {
      h = hh - 12;
      ampm = 'PM';
  } else if (hh === 12) {
      h = 12;
      ampm = 'PM';
  } else if (hh === 0) {
      h = 12;
  }

  // ie: 2014-03-24, 3:00 PM
  time = dd + '-' + mm + '-' + yyyy + ', ' + h + ':' + min + ' ' + ampm;
  return time;
}

const logger_1 = require("@whiskeysockets/baileys/lib/Utils/logger");
const logger = logger_1.default.child({});

const store = makeInMemoryStore({ logger: pino().child({ level: "silent", stream: "store" }) });
store.readFromFile('./baileys_store_multi.json');
// save every 10s
setInterval(() => {
store.writeToFile('./baileys_store_multi.json');
}, 10_000);


let sock;
let qr;
let soket;

//BEGIN connectToWhatsApp
async function connectToWhatsApp() {
  const { state, saveCreds } = await useMultiFileAuthState('baileys_auth_info')
// fetch latest version of WA Web
const { version, isLatest } = await fetchLatestBaileysVersion()
console.log(`using WA v${version.join('.')}, isLatest: ${isLatest}`)

sock = makeWASocket({
  //version,
      version: [2,2323,4],
  printQRInTerminal: true,
      logger: log({ level: "silent" }),
      auth: {
    creds: state.creds,
    /** caching makes the store faster to send/recv messages */
    keys: makeCacheableSignalKeyStore(state.keys, logger),
  },
  msgRetryCounterCache,
  generateHighQualityLinkPreview: true,
  // ignore all broadcast messages -- to receive the same
  // comment the line below out
   shouldIgnoreJid: jid => isJidBroadcast(jid),
  // implement to handle retries & poll updates
  getMessage,
})
  store.bind(sock.ev);
  sock.multi = true;
  const sendMessageWTyping = async(msg, jid) => {
  await sock.presenceSubscribe(jid)
  await delay(500)

  await sock.sendPresenceUpdate('composing', jid)
  await delay(2000)

  await sock.sendPresenceUpdate('paused', jid)

  await sock.sendMessage(jid, msg)
}
  sock.ev.on('connection.update', async (update) => {
      //console.log(update);
      const { connection, lastDisconnect } = update;
      if (connection === 'close') {
          let reason = new Boom(lastDisconnect.error).output.statusCode;
          if (reason === DisconnectReason.badSession) {
              console.log(`Bad Session File, Please Delete ${session} and Scan Again`);
              sock.logout();
          } else if (reason === DisconnectReason.connectionClosed) {
              console.log("Connection closed, reconnecting....");
              connectToWhatsApp();
          } else if (reason === DisconnectReason.connectionLost) {
              console.log("Connection Lost from Server, reconnecting...");
              connectToWhatsApp();
          }  else if (reason === DisconnectReason.loggedOut) {
              console.log(`Device Logged Out, Please Delete ${session} and Scan Again.`);
              sock.logout();
          } else if (reason === DisconnectReason.restartRequired) {
              console.log("Restart Required, Restarting...");
              connectToWhatsApp();
          } else if (reason === DisconnectReason.timedOut) {
              console.log("Connection TimedOut, Reconnecting...");
              connectToWhatsApp();
          } else {
              sock.end(`Unknown DisconnectReason: ${reason}|${lastDisconnect.error}`);
          }
      } else if (connection === 'open') {
          console.log('opened connection');
          let getGroups = await sock.groupFetchAllParticipating();
          let groups = Object.values(await sock.groupFetchAllParticipating())
          //console.log(groups);
          for (let group of groups) {
              console.log("id_group: " + group.id + " || Nama Group: " + group.subject);
          }
          return;
      }
      if (update.qr) {
          qr = update.qr;
          updateQR("qr");
      }
      else if (qr = undefined) {
          updateQR("loading");
      }
      else {
          if (update.connection === "open") {
              updateQR("qrscanned");
              return;
          }
      }
  });
  sock.ev.on("creds.update", saveCreds);
  // the process function lets you process all events that just occurred
// efficiently in a batch
sock.ev.process(
  // events is a map for event name => event data
  async(events) => {
    // something about the connection changed
    // maybe it closed, or we received all offline message or connection opened
      //console.log(messages);
      // something about the connection changed
      // maybe it closed, or we received all offline message or connection opened
      if(events['connection.update']) {
          const update = events['connection.update']
          const { connection, lastDisconnect } = update
          if(connection === 'close') {
              // reconnect if not logged out
              if((lastDisconnect.error).output.statusCode !== DisconnectReason.loggedOut) {
                  //startSock()
                  //connectToWhatsApp();
                  console.log('Connection closed. You are logged out. Please remove baileys_auth_info folder and log in again')
                  return;
              } else {
                  console.log('Connection closed. You are logged out.')
                  return;
              }
          }

          console.log('connection update', update)
      }

      // credentials updated -- save them
      if(events['creds.update']) {
          await saveCreds()
      }

      if(events['labels.association']) {
          console.log(events['labels.association'])
      }


      if(events['labels.edit']) {
          console.log(events['labels.edit'])
      }

      if(events.call) {
          console.log('recv call event', events.call)
      }

      // history received
      if(events['messaging-history.set']) {
          const { chats, contacts, messages, isLatest } = events['messaging-history.set']
          console.log(`recv ${chats.length} chats, ${contacts.length} contacts, ${messages.length} msgs (is latest: ${isLatest})`)
      }
      // received a new message
      if(events['messages.upsert']) {
      const upsert = events['messages.upsert'];
      console.log('recv messages ', JSON.stringify(upsert, undefined, 2));

          if(upsert.type === 'notify') {
              for(const msg of upsert.messages) {
                  const msgconversation = msg.message.conversation;
                  const msgconversationlowercase = msgconversation.toLowerCase();
                  if(!msg.key.fromMe && doReplies && msgconversationlowercase === "sayang") {
                  const msgfromme = msg.key.fromMe;
                  const upsertmsges = upsert.messages;
                  const sendername = upsertmsges[0].pushName;
                  //const timemsgreceivedlongformat = upsertmsges[0].message.messageContextInfo.deviceListMetadata.senderTimestamp
                  const timemsgreceivedlongformat = upsertmsges[0].messageTimestamp;

                  const timemsgreceivedlongformatstringFINAL = [timemsgreceivedlongformat].map(timemsgreceivedlongformatstring => String(timemsgreceivedlongformatstring));
                  console.log('timemsgreceivedlongformatstringFINAL result is' , timemsgreceivedlongformatstringFINAL);
                  const timemsgremovedfrontback = String((timemsgreceivedlongformatstringFINAL.slice(0, 3)).join(', ')) ;//https://stackoverflow.com/questions/49502683/how-to-return-the-array-without-the-brackets-javascript
                  console.log('timemsgremovedfrontback  is' , timemsgremovedfrontback);
                  // const resultdatemonthyear = date_format(timemsgremovedfrontback,'d-m-Y H:i:s') // use date_format
                  const resultdatemonthyear = convertTimestamp(timemsgremovedfrontback) ;// use convertTimestamp
                  console.log('resultdatemonthyear  is' , resultdatemonthyear);
                  //const sendernumberwithurl = messages[0].key.remoteJid;
                  const sendernumberwithurl = upsert.messages[0].key.remoteJid;
                  const msg0 = msg[0];
                  const msgkey = msg.key;
                  console.log('replying to', msg.key.remoteJid);
                  const sendernumber = sendernumberwithurl.split('@')[0]  // remove-everything-after-specific-character https://bobbyhadz.com/blog/javascript-remove-everything-after-specific-character-in-string
                  console.log('msgfromme is : ', msgfromme)
                  console.log('upsertmsges is : ', upsertmsges);
                  console.log('msg0 is : ', msg0);
                  console.log('msgkey is : ', msgkey);
                  console.log('msgconversationlowercase is : ', msgconversationlowercase);
                  console.log('sendername is : ', sendername);
                  console.log('sendernumber is : ', sendernumber);
                  console.log('timemsgreceivedlongformatstringFINAL is : ', timemsgreceivedlongformatstringFINAL);
                  await sock.readMessages([msg.key]);
                  await sendMessageWTyping(
                      { text: `Hai  ${sendername} ku sayang, apa yg kamu bilang sebentar tadi? Ternyata mesej kamu yg dihantar pada ${resultdatemonthyear} tadi benar2 mencairkan hatiku.`
                  } , msg.key.remoteJid
                      );
                  return;
                  
                  }
              }
              }
              
          }

      // messages updated like status delivered, message deleted etc.
    if(events['messages.update']) {
      console.log(
        JSON.stringify(events['messages.update'], undefined, 2)
      )

      for(const { key, update } of events['messages.update']) {
        if(update.pollUpdates) {
          const pollCreation = await getMessage(key)
          if(pollCreation) {
            console.log(
              'got poll update, aggregation: ',
              getAggregateVotesInPollMessage({
                message: pollCreation,
                pollUpdates: update.pollUpdates,
              })
            )
          }
        }
      }
    }

    if(events['message-receipt.update']) {
      console.log(events['message-receipt.update'])
    }

    if(events['messages.reaction']) {
      console.log(events['messages.reaction'])
    }

    if(events['presence.update']) {
      console.log(events['presence.update'])
    }

    if(events['chats.update']) {
      console.log(events['chats.update'])
    }

    if(events['contacts.update']) {
      for(const contact of events['contacts.update']) {
        if(typeof contact.imgUrl !== 'undefined') {
          const newUrl = contact.imgUrl === null
            ? null
            : await sock.profilePictureUrl(contact.id).catch(() => null)
          console.log(
            `contact ${contact.id} has a new profile pic: ${newUrl}`,
          )
        }
      }
    }

    if(events['chats.delete']) {
      console.log('chats deleted ', events['chats.delete'])
    }



  });
}
//END connectToWhatsApp

io.on("connection", async (socket) => {
  soket = socket;
  // console.log(sock)
  if (isConnected) {
      updateQR("connected");
  } else if (qr) {
      updateQR("qr");
  }
});

// functions
const isConnected = () => {
  return (sock.user);
};

const updateQR = (data) => {
  switch (data) {
      case "qr":
          qrcode.toDataURL(qr, (err, url) => {
              //soket.emit("qr", url);
              soket?.emit("qr", url);
              soket?.emit("log", "QR Code received, please scan!");
          });
          break;
      case "connected":
          soket?.emit("qrstatus", "./assets/check.svg");
          soket?.emit("log", "WhatsApp terhubung!");
          break;
      case "qrscanned":
          soket?.emit("qrstatus", "./assets/check.svg");
          soket?.emit("log", "QR Code Telah discan!");
          break;
      case "loading":
          soket?.emit("qrstatus", "./assets/loader.gif");
          soket?.emit("log", "Registering QR Code , please wait!");
          break;
      default:
          break;
  }
};

connectToWhatsApp()
  .catch(err => console.log("unexpected error: " + err)) // catch any errors




async function getMessage(key) {
  if (store) {
      const msg = await store.loadMessage(key.remoteJid, key.id);
      return (msg === null || msg === void 0 ? void 0 : msg.message) || undefined;
  }
  // only if store is present
  return baileys_1.proto.Message.fromObject({});
}

exports.sendMessage = async (req, res, next) => {
  try {
    let to = req.body.to || req.query.to;
    let text = req.body.text || req.query.text;
    let isGroup = req.body.isGroup || req.query.isGroup;
    const sessionId =
      req.body.session || req.query.session || req.headers.session;

    if (!to || !text) throw new ValidationError("Missing Parameters");

    const receiver = to;
    if (!sessionId) throw new ValidationError("Session Not Founds");
    const send = await whatsapp.sendTextMessage({
      sessionId,
      to: receiver,
      isGroup: !!isGroup,
      text,
    });

    res.status(200).json(
      responseSuccessWithData({
        id: send?.key?.id,
        status: send?.status,
        message: send?.message?.extendedTextMessage?.text || "Not Text",
        remoteJid: send?.key?.remoteJid,
      })
    );
  } catch (error) {
    next(error);
  }
};
exports.sendBulkMessage = async (req, res, next) => {
  try {
    const sessionId =
      req.body.session || req.query.session || req.headers.session;
    const delay = req.body.delay || req.query.delay || req.headers.delay;
    if (!sessionId) {
      return res.status(400).json({
        status: false,
        data: {
          error: "Session Not Found",
        },
      });
    }
    res.status(200).json({
      status: true,
      data: {
        message: "Bulk Message is Processing",
      },
    });
    for (const dt of req.body.data) {
      const to = dt.to;
      const text = dt.text;
      const isGroup = !!dt.isGroup;

      await whatsapp.sendTextMessage({
        sessionId,
        to: to,
        isGroup: isGroup,
        text: text,
      });
      await whatsapp.createDelay(delay ?? 1000);
    }
    console.log("SEND BULK MESSAGE WITH DELAY SUCCESS");
  } catch (error) {
    next(error);
  }
};
